(*| 21:49 15/07/1992 *)
PROGRAM GrafxBW;

{$M 32768, 0, 655360}

USES Dos,Crt,GXCommon,GXEdit,GXFiles;

PROCEDURE NotYet;
VAR
  C: CHAR;
BEGIN
  Writeln;
  Writeln('This feature not yet implemented. Press any key to continue');
  C := ReadKey;
END;  { NotYet }

PROCEDURE SetFileName(S: TFileName);
VAR
  Ext: STRING[3];
  P: INTEGER;
BEGIN
  FOR P := 1 TO Length(S) DO
    S[P] := UpCase(S[P]);
  IF Length(S) > 0 THEN BEGIN
    P := POS('.',S);
    IF P > 0 THEN BEGIN
      Ext := COPY(S,P+1,3);
      DELETE(S,P,Length(S) - P + 1);
      FOR P := 1 TO Length(Ext) DO
        Ext[P] := UpCase(Ext[P]);
      IF Ext = 'PCX' THEN
        FileFormat := PCX;
      IF Ext = 'GIF' THEN
        FileFormat := GIF;
      IF Ext = 'DAC' THEN
        FileFormat := DAC;
      IF Ext = 'PIC' THEN
        FileFormat := VGAP;
      IF Ext = 'EXE' THEN
        FileFormat := EXE;
      IF Ext = 'BMP' THEN
        FileFormat := BMP;
      IF Ext = 'RAW' THEN
        FileFormat := RAW;
    END;
    FileName := S;
  END;
END;  { SetFileName }

PROCEDURE GetFileName;
VAR
  S: TFileName;
BEGIN
  Readln(S);
  SetFileName(S);
END;  { GetFileName }

PROCEDURE LoadSavePrefix;
BEGIN
  Writeln;
  Writeln;
  IF Length(FileName) > 0 THEN BEGIN
    Writeln('Current name is ',FileName);
    Writeln;
  END;
END;  { LoadSavePrefix }

PROCEDURE Change_Format;
BEGIN
  ClrScr;
  Writeln('New File Format');
  Writeln;
  Writeln('    B .. Binary (GrafxBW)');
  Writeln;
  Writeln('    G .. GIF (CompuServe)');
  Writeln;
  Writeln('    P .. PCX (ZSoft PC PaintBrush)');
  Writeln;
  Writeln('    V .. VGAPaint');
  Writeln;
  Writeln('    E .. EXE (GrafxBW)');
  Writeln;
  Writeln('    M .. BMP (Microsoft)');
  Writeln;
  Writeln('    R .. RAW (Image Alchemy, Handmade Software Inc)');
  Writeln;
  Writeln('    Your choice : ');
  CASE UpCase(ReadKey) OF
    'B' : FileFormat := DAC;
    'G' : FileFormat := GIF;
    'P' : FileFormat := PCX;
    'V' : FileFormat := VGAP;
    'E' : FileFormat := EXE;
    'M' : FileFormat := BMP;
    'R' : FileFormat := RAW;
  END;
END;  { Change_Format }

PROCEDURE Do_Load;
BEGIN
  CASE FIleFormat OF
    DAC  : Load_DAC_Data;
    PCX  : Load_PCX_Data;
    GIF  : Load_GIF_Data;
    VGAP : Load_VGAP_Data;
    EXE  : Load_EXE_Data;
    BMP  : Load_BMP_Data;
    RAW  : Load_RAW_Data;
  END;
END;  { Do_Load }

PROCEDURE Load_Options;
BEGIN
  LoadSavePrefix;
  Write('Name of graphics image to load : ');
  GetFileName;
  Do_Load;
END;  { Load_Options }

PROCEDURE Save_Options;
BEGIN
  LoadSavePrefix;
  Write('Name of graphics image to save : ');
  GetFileName;
  CASE FIleFormat OF
    DAC  : Save_DAC_Data;
    PCX  : Save_PCX_Data;
    GIF  : NotYet;
    VGAP : Save_VGAP_Data;
    EXE  : Save_EXE_Data;
    BMP  : NotYet;
    RAW  : Save_RAW_Data;
  END;
END;  { Save_Options }

PROCEDURE ClearBuffers;
BEGIN
  FillChar(VBuf1^,SizeOf(TVideoBuffer),0);
  VBuf2^ := VBuf1^;
  FillChar(DacBuffer,SizeOf(TDacBuffer),0);
END;  { ClearBuffers }

PROCEDURE MainMenu;
VAR
  Done: BOOLEAN;
  C: CHAR;
BEGIN
  Done := FALSE;
  REPEAT
    ClrScr;
    Writeln('VGA 256 Colour Graphics Program by B Whitnall, V1.2');
    Writeln;
    Write('    F .. File format, currently ');
    ShowFormat;
    Writeln;
    Writeln;
    Writeln('    D .. Directory');
    Writeln;
    Writeln('    L .. Load graphics image');
    writeln;
    Writeln('    E .. Edit image');
    Writeln;
    Writeln('    S .. Save graphics image');
    Writeln;
    Writeln('    C .. Clear data buffers');
    Writeln;
    Writeln('    Q .. Quit program');
    Writeln;
    Writeln('    Your choice : ');
    CASE UpCase(ReadKey) OF
      'F' : Change_Format;
      'D' : File_Directory;
      'L' : Load_Options;
      'E' : Edit_Commands;
      'S' : Save_Options;
      'C' : ClearBuffers;
      'Q',
      #27 : Done := TRUE;
    END;
  UNTIL Done;
END;  { MainMenu }

BEGIN
  IF ParamCount > 0 THEN BEGIN
    SetFileName(ParamStr(1));
    Write('Loading ',FileName,', ');
    ShowFormat;
    Do_Load;
    Edit_Commands;
  END;
  MainMenu;
END.
